function [sigma_breve_plot,sigma_C_post_plot,y_breve_plot] = ...
    fault_slip_sigma_breve_plot_2(a,alpha,b,ddelta_dy,delta,delta_c,D_center,...
    Delta_y_int,eps_reg,eta_reg,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
    p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_plot_max,y_plot_min)
%
% Computes slip-induced stresses at the fault in points governed by y_sigma between y_plot_min
% and y_plot_max. Valid for the top patch with slip-weakening friction and no merging.

% Recover grid info (see fault_slip_delta.m for definitions):
help_01 = y_delta(2:end-1);
help_02 = help_01 < 0;
help_03 = help_01 > 0;
y_bot = help_01(help_02);
y_top = help_01(help_03);
n_y_bot = length(y_bot);
ddelta_dy_bot = ddelta_dy(2:n_y_bot+1);
ddelta_dy_top = ddelta_dy(n_y_bot+2:end-1);
% y_sigma_active = nonzeros( (y_plot_min < y_sigma) .* y_sigma .* ...
%     (y_sigma < y_plot_max) )'; % cropped
% sigma_C_active = nonzeros( (y_plot_min < y_sigma) .* sigma_C .* ...
%     (y_sigma < y_plot_max) )';

n_pt_y = (y_plot_max - y_plot_min)/Delta_y_int;
[~,~,~,sigma_C_post,~,~,~,~,~,~,~,~,~,~,~,~,~,~,y_sigma_C_post] = ...
    fault_slip_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,2,flag_reg,g,...
    kappa,K_eff,mu_dyn,mu_st,n_pt_y,nu,p_0_center,p_inc,phi,rho_f,rho_s,...
    sigma_v_0,theta,y_delta,y_plot_max,y_plot_min);

% Compute slip-induced stresses:
[sigma_breve_top_1,y_breve_top] = fault_slip_sigma_breve_2(ddelta_dy_top,G,...
    0,nu,y_top,y_sigma_C_post,y_sigma_C_post); % direct terms
% [sigma_breve_top_2,~] = fault_slip_sigma_breve(ddelta_dy_bot,dy_bot,G,...
%     n_pts,nu,y_bot,y_plot_max_delta_2,y_plot_min_delta_2); % cross terms
% sigma_breve_plot = sigma_breve_top_1 + sigma_breve_top_2;
sigma_breve_plot = sigma_breve_top_1;
sigma_C_post_plot = sigma_C_post - sigma_breve_plot; 
y_breve_plot = y_breve_top;

